<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:variable name="refno"></xsl:variable>
	<xsl:template match="/">
		<table id='tbl' width='100%' border='1' cellspacing='0' cellpadding='1' bordercolordark='#FFFFFF' bordercolor='#777777' style='font-family: Arial, Helvetica; font-size: 8pt;'>
			<tr height='24' style='color:captiontext;' bgcolor='activecaption'>
				<th colspan="12">
					<div align="left">PARTS LIST</div>
				</th>
			</tr>
			<tr height='23' bgcolor='threedface'>
				<th><br/></th>
				<th>CHG</th>
<!--
				<th width='20' style="font-family:JVC Service,Arial,Helvetica">!</th>
-->
				<th width='20'><img src="../js/safety.png" width="12" height="10" border="0"/></th>
				<th>REF</th>
				<th>OR</th>
				<th>PARTS NO</th>
				<th>PARTS NAME</th>
				<th>DESCRIPTION</th>
				<th>AREA</th>
				<th>QTY</th>
				<th>BLOCK</th>
				<th>MCI</th>
			</tr>
			<xsl:if test="$refno != ''">
				<xsl:apply-templates select="//ROW[contains(SYMBOL,$refno)]">
					<xsl:sort select="BLOCK_NO" data-type="text" order="ascending"/>
					<xsl:sort select="@SORT" data-type="text" order="ascending"/>
				</xsl:apply-templates>
			</xsl:if>
			<xsl:if test="$refno = ''">
				<xsl:apply-templates select="//ROW">
					<xsl:sort select="BLOCK_NO" data-type="text" order="ascending"/>
					<xsl:sort select="@SORT" data-type="text" order="ascending"/>
				</xsl:apply-templates>
			</xsl:if>
		</table>
	</xsl:template>
	
	<xsl:template match="/PARTSLIST/ROW">
		<tr height='23'>
			<xsl:attribute name="id">
				<xsl:value-of select="BLOCK_NO"/><xsl:value-of select="SYMBOL"/>
			</xsl:attribute>
			<td nowrap="nowrap">
				<input type="button" id="odrBtn" value="ORDER..." title='Click to oder'>
					<xsl:attribute name="onclick">
						addBasket('<xsl:value-of select="SYMBOL"/>','<xsl:value-of select="PART_NO"/>','<xsl:value-of select="PART_NAME"/>','<xsl:value-of select="BLOCK_NO"/>',1)
					</xsl:attribute>
					<xsl:if test="@CHG[. = 'D']">
						<xsl:attribute name="disabled">
							true
						</xsl:attribute>
					</xsl:if>
				</input>
			</td>
			<td nowrap="nowrap" align="center">
				<xsl:if test="@CHG[. != '']"><xsl:value-of select="@CHG"/></xsl:if>
				<xsl:if test="@CHG[. = '']"><br/></xsl:if>
			</td>
			<td align="center" nowrap="nowrap">
				<xsl:if test="SAFETY_FLG[. != '']">
<!--
					<xsl:attribute name="style">font-family:JVC Service,Arial,Helvetica</xsl:attribute>
					<xsl:value-of select="SAFETY_FLG"/>
-->
					<img src="../js/safety.png" width="12" height="10" border="0"/>
				</xsl:if>
				<xsl:if test="SAFETY_FLG[. = '']">
					<br/>
				</xsl:if>
			</td>
			<td>
				<a>
					<xsl:attribute name="href">
						javascript:searchParts('<xsl:value-of select="SYMBOL"/>','<xsl:value-of select="FILE1"/>','<xsl:value-of select="FILE2"/>')
					</xsl:attribute>
					<xsl:if test="SYMBOL[. != '']"><xsl:value-of select="SYMBOL"/></xsl:if>
					<xsl:if test="SYMBOL[. = '']"><br/></xsl:if>
				</a>
			</td>
			<td nowrap="nowrap">
				<xsl:if test="OR_FLG[. != '']"><xsl:value-of select="OR_FLG"/></xsl:if>
				<xsl:if test="OR_FLG[. = '']"><br/></xsl:if>
			</td>
			<td nowrap="nowrap">
				<xsl:if test="PART_NO[. != '']"><xsl:value-of select="PART_NO"/></xsl:if>
				<xsl:if test="PART_NO[. = '']"><br/></xsl:if>
			</td>
			<td nowrap="nowrap">
				<xsl:if test="PART_NAME[. != '']"><xsl:value-of select="PART_NAME"/></xsl:if>
				<xsl:if test="PART_NAME[. = '']"><br/></xsl:if>
			</td>
			<td>
				<xsl:if test="DESCRIPTION[. != '']"><xsl:value-of select="DESCRIPTION"/></xsl:if>
				<xsl:if test="DESCRIPTION[. = '']"><br/></xsl:if>
			</td>
			<td>
				<xsl:if test="AREA[. != '']"><xsl:value-of select="AREA"/></xsl:if>
				<xsl:if test="AREA[. = '']"><br/></xsl:if>
			</td>
			<td nowrap="nowrap">
				<xsl:if test="QTY[. != '']"><xsl:value-of select="QTY"/></xsl:if>
				<xsl:if test="QTY[. = '']"><br/></xsl:if>
			</td>
			<td nowrap="nowrap">
				<xsl:if test="BLOCK_NO[. != '']"><xsl:value-of select="BLOCK_NO"/></xsl:if>
				<xsl:if test="BLOCK_NO[. = '']"><br/></xsl:if>
			</td>
			<td nowrap="nowrap">
				<a>
					<xsl:attribute name="href">
						<xsl:value-of select="RESERVED1/@LINK"/>
					</xsl:attribute>
					<xsl:attribute name="target">_blank</xsl:attribute>
					<xsl:if test="RESERVED1[. != '']"><xsl:value-of select="RESERVED1"/></xsl:if>
					<xsl:if test="RESERVED1[. = '']"><br/></xsl:if>
				</a>
			</td>
		</tr>
	</xsl:template>
</xsl:stylesheet>
